IF NOT EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME='EST_PROD_PRECO_ALT_CPL_AUDIT') 
BEGIN
	CREATE TABLE [dbo].[EST_PROD_PRECO_ALT_CPL_AUDIT](
	[CD_CTR_AUDIT] [bigint] IDENTITY(1,1) NOT NULL,
	[CD_EMP] [int] NOT NULL,
	[CD_ALT_PRECO] [int] NOT NULL,

	[CD_PROD] [int] NOT NULL,
	[VLR_TABELA_ANT] [money] NULL,
	[VLR_TABELA_ATU] [money] NULL,
	[VLR_OFERTA] [money] NOT NULL DEFAULT (0),

	[TP_EVENTO] [char](1) NOT NULL,
	[DT_EVENTO] [datetime] NOT NULL,
	[CD_USU] [int] NOT NULL,
	[IP_CLIENTE] [sql_variant] NOT NULL,
	[HOST] [varchar](max) NOT NULL,
	[APPNAME] [varchar](1000) NULL,

	CONSTRAINT [PK_EST_PROD_PRECO_ALT_CPL_AUDIT] PRIMARY KEY CLUSTERED 
	(
		[CD_CTR_AUDIT] ASC
	)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90) ON [PRIMARY]
	) ON [PRIMARY]

	ALTER TABLE [dbo].[EST_PROD_PRECO_ALT_CPL_AUDIT] ADD  CONSTRAINT [DF_EST_PROD_PRECO_ALT_CPL_AUDIT_DT_EVENTO]  DEFAULT (getdate()) FOR [DT_EVENTO]

	ALTER TABLE [dbo].[EST_PROD_PRECO_ALT_CPL_AUDIT] ADD  CONSTRAINT [DF_EST_PROD_PRECO_ALT_CPL_AUDIT_IP_CLIENTE]  DEFAULT (connectionproperty('CLIENT_NET_ADDRESS')) FOR [IP_CLIENTE]

	ALTER TABLE [dbo].[EST_PROD_PRECO_ALT_CPL_AUDIT] ADD  CONSTRAINT [DF_EST_PROD_PRECO_ALT_CPL_AUDIT_HOST]  DEFAULT (host_name()) FOR [HOST]

	ALTER TABLE [dbo].[EST_PROD_PRECO_ALT_CPL_AUDIT] ADD  CONSTRAINT [DF_EST_PROD_PRECO_ALT_CPL_AUDIT_APPNAME]  DEFAULT (app_name()) FOR [APPNAME]
	
END

IF NOT EXISTS (SELECT * FROM SYS.INDEXES WHERE NAME = 'IX_EST_PROD_PRECO_ALT_CPL_AUDIT')
BEGIN
    CREATE NONCLUSTERED INDEX [IX_EST_PROD_PRECO_ALT_CPL_AUDIT] ON EST_PROD_PRECO_ALT_CPL_AUDIT
(
    [CD_EMP] ASC,
    [CD_ALT_PRECO] ASC,
	[CD_USU] ASC,
	[CD_PROD] ASC,
	[DT_EVENTO] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
END